/*
 * Decompiled with CFR 0.152.
 */
package scientific;

public abstract class Symbol {
    protected final int id;
    protected String value = null;
    protected Symbol leftChild = null;
    protected Symbol rightChild = null;

    public Symbol(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public void addChild(Symbol child, int index) {
        if (index == 1) {
            this.rightChild = child;
        } else if (index == 0) {
            this.leftChild = child;
        } else {
            throw new IllegalStateException("Symbol " + this + " does not support child no. " + index);
        }
    }

    public void dump(String prefix) {
        if (prefix == null || prefix.length() == 0) {
            System.out.println();
        }
        System.out.println(prefix + this);
        if (this.leftChild != null) {
            this.leftChild.dump(prefix + " ");
        }
        if (this.rightChild != null) {
            this.rightChild.dump(prefix + " ");
        }
    }

    public String toString() {
        return this.value;
    }

    public abstract double calculate(boolean var1);
}

